<?php
/*
Plugin Name: Rwanda Hospitality Hub CV Builder
Description: Hospitality CV Builder with Pay-to-Download via PayPack (2000 RWF).
Version: 1.0
Author: Rwanda Hospitality Hub
*/

if (!defined("ABSPATH")) exit;

// Includes
require_once plugin_dir_path(__FILE__) . "includes/db-setup.php";
require_once plugin_dir_path(__FILE__) . "includes/shortcode.php";
require_once plugin_dir_path(__FILE__) . "includes/paypack-config.php";
require_once plugin_dir_path(__FILE__) . "includes/paypack-auth.php";
require_once plugin_dir_path(__FILE__) . "includes/payment.php";
require_once plugin_dir_path(__FILE__) . "includes/webhook.php";
require_once plugin_dir_path(__FILE__) . "includes/download.php";

// Enqueue assets
function rwh_cv_builder_assets() {
    wp_enqueue_style(
        "rwh-builder-css",
        plugin_dir_url(__FILE__) . "assets/css/builder.css"
    );
    wp_enqueue_script(
        "rwh-builder-js",
        plugin_dir_url(__FILE__) . "assets/js/builder.js",
        array("jquery"),
        null,
        true
    );
    wp_localize_script("rwh-builder-js", "rwhCV", array(
        "ajax_url" => admin_url("admin-ajax.php")
    ));
}
add_action("wp_enqueue_scripts", "rwh_cv_builder_assets");
